#pragma once
#include <vector>
#include "arrayutils.h"
//*******************************************************************************************************
//Trida reprezentujici seznam nejakych prvku, s dynamickym polem
//*******************************************************************************************************
template <class dType> class CList
{
private:
	std::vector<dType>				m_Array;	//pole prvku
public:
	CList()							{;}
	~CList(void)						{Clear();}

	void							Add(dType Item);
	void							AddUnique(dType Item);
    bool							Contains(dType Item);
	bool							Remove(dType Item);
	void							Clear();

	unsigned int					Size();
	dType							operator [] (int index);
};

//*******************************************************************************************************
//Fce pro pridani prvku do seznamu
//*******************************************************************************************************
template <class dType> void CList<dType>::Add(dType Item)
{
	//jen volani metody push_back pro pridani prvku na konec pole
	m_Array.push_back(Item);
}
//*******************************************************************************************************
//Fce pro zjisteni zda je zadany prvek v poli
//*******************************************************************************************************
template <class dType> bool CList<dType>::Contains(dType Item)
{
	//zkusime prvek najit v setridenem poli
	for (unsigned int i = 0; i < m_Array.size(); i++)
		if (m_Array[i] == Item)
			return true;

	return false;
}
//*******************************************************************************************************
//Prida unikatni prvek
//*******************************************************************************************************
template <class dType> void CList<dType>::AddUnique(dType Item)
{
	//nejdriv zjistime jestli prvek v poli je, pokud ne, tak ho pridame
	if (!Contains(Item))
		Add(Item);
}
//*******************************************************************************************************
//Fce pro odstraneni prvku ze seznamu
//*******************************************************************************************************
template <class dType> bool CList<dType>::Remove(dType Item)
{
	unsigned int i = 0;

	//zjisti pozici prvku v poli
	unsigned int iPos = 0;
	for (iPos; iPos < m_Array.size(); iPos++)
		if (m_Array[iPos] == Item)
			break;

	//prerovnani vsech prvku vpravo od pozice nalezeneho
	for (i = (unsigned int)iPos; i < (unsigned int)m_Array.size() - 1; i++)
		m_Array[i] = m_Array[i+1];

	m_Array.pop_back();

	return true;
}
//*******************************************************************************************************
//Fce pro uvolneni celeho pole
//*******************************************************************************************************
template <class dType> void CList<dType>::Clear()
{
	m_Array.clear();
}
//*******************************************************************************************************
//vraci velikost seznamu, pocet prvku v seznamu
//*******************************************************************************************************
template <class dType> unsigned int CList<dType>::Size()
{
	return (int)m_Array.size();
}
//*******************************************************************************************************
//operator pro vyber ze seznamu
//*******************************************************************************************************
template <class dType> dType CList<dType>::operator [] (int index)
{
	return m_Array[index];
}